# Contribution Guide

First off, thank you for considering contributing to `wpackio-enqueue`. It's people like you that make `wpackio-enqueue` such a great tool.

## How to contribute

Prerequisites:

- Familiarity with [pull requests](https://help.github.com/articles/using-pull-requests) and [issues](https://guides.github.com/features/issues/).
- Knowledge of [PHP](https://php.net) and [WordPress API](https://developer.wordpress.org).

Now let's dive in.

## Pull Request Process

1. Ensure all lints and tests are passing before creating a pull request. If you
   just working on it, and would like to have a review, start your PR title with `[WIP]`.
2. Make sure you add tests to any new features you are adding. We have a strict
   100% coverage policy here. Codecov checks for it under every PR.
3. Update the README.md with details of changes to the interface, this includes new environment
   variables, exposed ports, useful file locations and container parameters.

## Release a version

1. Ensure you have `npx` installed.
2. Run `composer run-script changelog <new version>`, like `composer run-script changelog 2.0.0`.
3. Commit the changelog and tag it.

# Conduct

We are committed to providing a friendly, safe and welcoming environment for
all, regardless of gender, sexual orientation, disability, ethnicity, religion,
or similar personal characteristic.

On communication, please avoid using overtly sexual nicknames or other nicknames that
might detract from a friendly, safe and welcoming environment for all.

Please be kind and courteous. There's no need to be mean or rude.
Respect that people have differences of opinion and that every design or
implementation choice carries a trade-off and numerous costs. There is seldom
a right answer, merely an optimal answer given a set of values and
circumstances.

Please keep unstructured critique to a minimum. If you have solid ideas you
want to experiment with, make a fork and see how it works.

We will exclude you from interaction if you insult, demean or harass anyone.
That is not welcome behaviour. We interpret the term "harassment" as
including the definition in the
[Citizen Code of Conduct](http://citizencodeofconduct.org/);
if you have any lack of clarity about what might be included in that concept,
please read their definition. In particular, we don't tolerate behavior that
excludes people in socially marginalized groups.

Private harassment is also unacceptable. No matter who you are, if you feel
you have been or are being harassed or made uncomfortable by a community
member, please contact one of the channel ops or any of the
[CONTRIBUTING.md](https://github.com/jden/CONTRIBUTING.md) core team
immediately. Whether you're a regular contributor or a newcomer, we care about
making this community a safe place for you and we've got your back.

Likewise any spamming, trolling, flaming, baiting or other attention-stealing
behaviour is not welcome.

# Communication

Currently we do not have any dedicated channel for communication. But you can
ask me directly at [twitter](https://twitter.com/swashata) or hashtag `#wpackio`.

GitHub issues are the primary way for communicating about specific proposed
changes to this project.

In both contexts, please follow the conduct guidelines above. Language issues
are often contentious and we'd like to keep discussion brief, civil and focused
on what we're actually doing, not wandering off into too much imaginary stuff.

# Frequently Asked Questions

## What is the brain monkey thing I see in tests?

It is an awesome library found [here](https://brain-wp.github.io/BrainMonkey/).

I have wriiten a little about it [here](https://swas.io/blog/wordpress-plugin-unit-test-with-brainmonkey/).
